#include "SimulationEngineCommunication.h"

namespace SimulationEngine
{

SimulationEngineCommunication::SimulationEngineCommunication()
{
	/*Send Socket*/
	ConfigurationServer *config = ConfigurationServer::GetInstance();	
	sendsocket = socket(AF_INET,SOCK_DGRAM,0);
	memset( &sendname, 0, sizeof(sendname));
	sendname.sin_family = AF_INET;
	sendname.sin_port = htons(config->GetCommunicationReceiverPort());
	sendname.sin_addr.s_addr = inet_addr(config->GetCommunicationReceiverIP().data());
	
	/*Receive Socket*/
	receivename.sin_family = AF_INET;
	receivename.sin_port = htons(config->GetSimulationEnginePort());
	receivename.sin_addr.s_addr =htonl(INADDR_ANY);
	receivesocket = socket(AF_INET, SOCK_DGRAM, 0);
	int length = sizeof(receivename);
	if (bind(receivesocket,(struct sockaddr *)&receivename,length))
	{
		printf("Warning: Bind Error\n");
	}
	if (getsockname(receivesocket,(struct sockaddr *)&receivename,(socklen_t *)&length))
		printf("Warning: Name Error\n");
	fcntl(receivesocket,F_SETFL, O_NONBLOCK);	
	maximumdatagramsize = config->GetMaximumDatagramSize();
}

SimulationEngineCommunication::~SimulationEngineCommunication()
{
	close (receivesocket);
	close (sendsocket);
}

string SimulationEngineCommunication::GetMessage()
{
	string ret;
	char buffer[maximumdatagramsize];
	int resp = read(receivesocket,buffer,maximumdatagramsize);
	if (resp!=-1)
	{
		ret = buffer;
	}
	return ret;
}
void SimulationEngineCommunication::SendMessage(string message)
{
	sendto(sendsocket,message.data(), message.size()+1,0,(struct sockaddr *)&sendname,sizeof(sendname));
}

void SimulationEngineCommunication::FreeResources()
{
	close(sendsocket);
	close(receivesocket);
}

}
